using System;

namespace SimpleIndexer
{
	// Uproszczona kontrolka typu ListBox 
	public class ListBoxTest
	{
		private string[] strings;
		private int ctr = 0;

		// Inicjowanie kontrolki przy uyciu acuchw znakw 
		public ListBoxTest(params string[] initialStrings)
		{
			// Przydzielanie pamici dla acuchw znakw 
			strings = new String[256];

			// Kopiowanie acuchw znakw przekazanych do konstruktora 
			foreach (string s in initialStrings)
			{
				strings[ctr++] = s;
			}
		}

		// Dodawanie pojedynczego acucha znakw na koniec listy
		public void Add(string theString)
		{
			if (ctr >= strings.Length)
			{
				// Obsuga niepoprawnych indeksw
			}
			else
				strings[ctr++] = theString;
		}

		// Umoliwienie dostpu jak do tablicy 

		public string this[int index]
		{
			get
			{
				if (index < 0 || index >= strings.Length)
				{
					// Obsuga niepoprawnych indeksw
				}
				return strings[index];
			}
			set
			{
				// Dodawanie elementw jest moliwe jedynie przy uyciu metody add
				if (index >= ctr)
				{
					// Obsuga bdw
				}
				else
					strings[index] = value;
			}
		}

		// Informuje o liczbie przechowywanych acuchw znakw 
		public int GetNumEntries()
		{
			return ctr;
		}
	}

	public class Tester
	{
		static void Main()
		{
			// Tworzenie i inicjowanie nowej listy
			ListBoxTest lbt =
			new ListBoxTest("Witaj", "wiecie");

			// Dodawanie kilku acuchw znakw 
			lbt.Add("Proust");
			lbt.Add("Faulkner");
			lbt.Add("Mann");
			lbt.Add("Hugo");

			// Testowanie dostpu
			string subst = "Wszechwiecie";
			lbt[1] = subst;

			// Dostp do wszystkich acuchw znakw 
			for (int i = 0; i < lbt.GetNumEntries(); i++)
			{
				Console.WriteLine("lbt[{0}]: {1}", i, lbt[i]);
			}
		}
	}
}
